//=============================================================================
// WeaponC4.
//=============================================================================
class C4Detonator extends DeusExWeapon;

var localized String shortName;

function Fire( float value)
{      
        	local C4 myLam;
	
        	ForEach AllActors( Class'C4', myLam )
        	{
                	if ( (myLam != None) && ((myLam.Owner != None) && (myLam.Owner == Owner)) )
                	{
	               		myLam.Explode(myLam.Location, Vector(myLam.Rotation));
                                myLam.Destroy();
                                PlaySound(Sound'DeusExSounds.Weapons.LAMSelect');
                	}
        	}               		
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot <= 9);
}

defaultproperties
{
     ShortName="Detonator"
     LowAmmoWaterMark=2
     GoverningSkill=Class'DeusEx.SkillDemolition'
     EnviroEffective=ENVEFF_AirWater
     Concealability=CONC_All
     ShotTime=0.500000
     reloadTime=0.100000
     HitDamage=50
     maxRange=4800
     bHandToHand=False
     AccurateRange=2400
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     mpReloadTime=0.100000
     mpHitDamage=50
     mpBaseAccuracy=1.000000
     mpAccurateRange=2400
     mpMaxRange=2400
     ReloadCount=0
     PickupAmmoCount=0
     FireOffset=(Y=10.000000,Z=20.000000)
     shakemag=50.000000
     SelectSound=Sound'DeusExSounds.Weapons.LAMSelect'
     InventoryGroup=241
     ItemName="C4 Detonator"
     PlayerViewOffset=(Y=-13.000000,Z=-19.000000)
     PlayerViewMesh=LodMesh'DeusExItems.GasGrenade'
     PickupViewMesh=LodMesh'DeusExItems.GasGrenadePickup'
     ThirdPersonMesh=LodMesh'DeusExItems.GasGrenade3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconGasGrenade'
     largeIcon=Texture'DeusExUI.Icons.LargeIconGasGrenade'
     largeIconWidth=35
     largeIconHeight=45
     Description="A multi-functional explosive with electronic priming system that can either be thrown or attached to any surface with its polyhesive backing and used as a proximity mine or as a remote explosive.|n|n<UNATCO OPS FILE NOTE SC093-BLUE> Disarming a proximity device should only be attempted with the proper demolitions training. Trust me on this. -- Sam Carter <END NOTE>"
     beltDescription="|p2C4 DET"
     Mesh=LodMesh'DeusExItems.GasGrenadePickup'
     CollisionRadius=3.800000
     CollisionHeight=3.500000
     Mass=5.000000
     Buoyancy=2.000000
}
